# Written by Petru Paler, Uoti Urpala, Ross Cohen and John Hoffman
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from utility import getABCUtility

def decode_func(x, f, w):
    if x[f] == 'd':
        r = {}
        f += 1
        lastkey = None
        while x[f] != 'e':
            if not ('0' <= x[f] <= '9'):
                raise ValueError
            k, f, w = decode_func(x, f, w)
            if k in r or lastkey > k:
                w = True
            lastkey = k
            r[k], f, w = decode_func(x, f, w)
        f += 1
    elif x[f] == 'l':
        r = []
        f += 1
        while x[f] != 'e':
            v, f, w = decode_func(x, f, w)
            r.append(v)
        f += 1
    elif x[f] == 'i':
        oldf = f + 1
        f = x.index('e', oldf)
        if x[oldf] == '0' and f != oldf + 1 or x[oldf:oldf + 2] == '-0':
            w = True
        try:
            r = int(x[oldf:f])
        except:
            r = long(x[oldf:f])
        f += 1
    elif '0' <= x[f] <= '9':
        colon = x.index(':', f)
        if x[f] == '0' and colon != f + 1:
            w = True
        try:
            f = int(x[f:colon])
        except (OverflowError, ValueError):
            f = long(x[f:colon])
        colon += 1
        f += colon
        r = x[colon:f]
    else:
        raise ValueError
    return r, f, w

def bdecode(x, sloppy = 0, length = False):
    # sloppy : to handle wrong length
    # 0 : raise exception
    # 1 : do as if good
    # 2 : return warning only

    # Warning if something went wrong but does not prevent the torrent from loading
    # (Keys not sorted in dictionary, integers with leading zeros, bad zero format)
    w = False
    try:
        r, l, w = decode_func(x, 0, w)
    except (IndexError, KeyError, ValueError):
        raise ValueError, getABCUtility().lang.get('badencodeddata')
    if l != len(x) or w:
        if sloppy == 0:
            raise ValueError, getABCUtility().lang.get('badencodeddata')
        elif sloppy == 2:
            if length:
                return r, l, True
            else:
                return r, True
    elif sloppy == 2:
        if length:
            return r, l, False
        else:
            return r, False
    if length:
        return r, l
    else:
        return r


bencached_marker = []


class Bencached:
    def __init__(self, s):
        self.marker = bencached_marker
        self.bencoded = s


BencachedType = type(Bencached('')) # insufficient, but good as a filter

def encode_bencached(x, r):
    assert x.marker == bencached_marker
    r.append(x.bencoded)

def encode_int(x, r):
    r.extend(('i', str(x), 'e'))

def encode_bool(x, r):
    encode_int(int(x), r)

def encode_string(x, r):    
    r.extend((str(len(x)), ':', x))

def encode_unicode(x, r):
    #r.append('u')
    encode_string(x.encode('UTF-8'), r)

def encode_list(x, r):
        r.append('l')
        for e in x:
            encode_func[type(e)](e, r)
        r.append('e')

def encode_dict(x, r):
    r.append('d')
    ilist = x.items()
    ilist.sort()
    for k, v in ilist:
        r.extend((str(len(k)), ':', k))
        encode_func[type(v)](v, r)
    r.append('e')

encode_func = {}
encode_func[BencachedType] = encode_bencached
encode_func[int] = encode_int
encode_func[long] = encode_int
encode_func[str] = encode_string
encode_func[list] = encode_list
encode_func[tuple] = encode_list
encode_func[dict] = encode_dict
encode_func[bool] = encode_bool
encode_func[unicode] = encode_unicode
    
def bencode(x):
    r = []
    try:
        encode_func[type(x)](x, r)
    except:
        print "*** error *** could not encode type %s (value: %s)" % (type(x), x)
        assert 0
    return ''.join(r)
