# Updated and modified for ABC_OKC : Old King Cole
product_name = 'ABC_OKC'
version = '4.4.51'
version_short = 'AO' + version
USERAGENT = [product_name + '/' + version_short, product_name + ' ' + version]

def setUserAgent(useragent, userextended):
    global USERAGENT
    USERAGENT[0] = useragent
    USERAGENT[1] = userextended

from hashlib import sha1
from time import time, clock
from binascii import unhexlify
from random import seed, choice

from utility import getABCUtility

try:
    from os import getpid
except ImportError:
    def getpid():
        return 1

mapbase64 = '0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz.-'
lettersu = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
lettersl = 'abcdefghijklmnopqrstuvwxyz'
digits = '0123456789'

_idprefix = version_short[:2]
for subver in version_short[2:].split('.'):
    try:
        subver = int(subver)
    except:
        subver = 0
    _idprefix += mapbase64[subver]
_idprefix += ('-' * (6 - len(_idprefix)))
_idrandoms = [None] * 4

def initSeed():
    try:
        f = open('/dev/urandom', 'rb')
        x = f.read(20)
        f.close()
    except:
        x = ''

    l1 = 0
    t = clock()
    while t == clock():
        l1 += 1
    l2 = 0
    t = long(time() * 100)
    while t == long(time() * 100):
        l2 += 1
    l3 = 0
    if l2 < 1000:
        t = long(time() * 10)
        while t == long(clock() * 10):
            l3 += 1
    x += (repr(time()) + '/' + str(time()) + '/'
          + str(l1) + '/' + str(l2) + '/' + str(l3) + '/'
          + str(getpid()))

    s = ''
    for i in sha1(x).digest()[-11:]:
        s += mapbase64[ord(i) & 0x3F]
    seed(s)
    return s

def resetPeerID():
    return initSeed()

def resetUserPeerID(slots = [1, 2, 3], userids = None, useridmasks = None):
    initSeed()
    status = []
    idrandoms = []
    for s in slots:
        # Translate quoted hex data
        if userids is None:
            userid = getABCUtility().abcparams['userid' + str(s)].encode()
        else:
            userid = userids.pop(0).encode()
        if useridmasks is None:
            useridmask = getABCUtility().abcparams['useridmask' + str(s)].upper()
        else:
            useridmask = useridmasks.pop(0).upper()
        useridlen = len(userid)
        if useridmask:
            if len(useridmask) != 20:
                status.append(3)
                idrandoms.append(None)
                continue
            error = False
            for i in xrange(20):
                if useridmask[i] != 'F' and useridmask[i] != 'R':
                    status.append(4)
                    idrandoms.append(None)
                    error = True
                    break
            if error:
                continue
        if userid:
            useridhex = ''
            i = 0
            error = False
            while i < useridlen:
                if userid[i] == '\\':
                    if i != useridlen - 1 and userid[i + 1] == '\\':
                        useridhex += '\\'
                        i += 2
                    else:
                        try:
                            useridhex += unhexlify(userid[i + 1:i + 3])
                        except:
                            status.append(1)
                            idrandoms.append(None)
                            error = True
                            break
                        i += 3
                else:
                    useridhex += userid[i]
                    i += 1
            if error:
                continue
            if len(useridhex) != 20:
                status.append(2)
                idrandoms.append(None)
                continue
            # Apply randomizing mask
            if useridmask:
                idrandom = ''
                error = False
                for i in xrange(20):
                    if useridmask[i] == 'F':
                        # Fixed
                        idrandom += useridhex[i]
                    else:
                        # Random
                        if useridhex[i] == 'A':
                            # Uppercase letter
                            idrandomchar = choice(lettersu)
                        elif useridhex[i] == 'a':
                            # Lowercase letter
                            idrandomchar = choice(lettersl)
                        elif useridhex[i] == 'B':
                            # Uppercase letter or digit
                            idrandomchar = choice(lettersu + digits)
                        elif useridhex[i] == 'b':
                            # Lowercase letter or digit
                            idrandomchar = choice(lettersl + digits)
                        elif useridhex[i] == '1':
                            # Digit
                            idrandomchar = choice(digits)
                        elif useridhex[i] == '?':
                            # Any letter
                            idrandomchar = choice(lettersu + lettersl)
                        elif useridhex[i] == '*':
                            # Any letter or digit
                            idrandomchar = choice(lettersu + lettersl + digits)
                        elif useridhex[i] == '.':
                            # Any byte
                            idrandomchar = chr(choice(xrange(256)))
                        else:
                            status.append(5)
                            idrandoms.append(None)
                            error = True
                            break
                        idrandom += idrandomchar
                if error:
                    continue
                idrandoms.append(idrandom)
            else:
                idrandoms.append(useridhex)
        else:
            idrandoms.append(None)
        status.append(0)
    return status, idrandoms

def initPeerID():
    _idrandoms[0] = resetPeerID()
    status, idrandoms = resetUserPeerID()
    for i in xrange(3):
        if status[i] == 0:
            _idrandoms[i + 1] = idrandoms[i]

def createPeerID(ins = '---', useragentidnb = None, idrandoms = None):
    if useragentidnb is None:
        useragentidnb = int(getABCUtility().abcparams['useragentid'])
    if idrandoms is None:
        idrandoms = _idrandoms
    if useragentidnb == 0:
        assert type(ins) == str
        assert len(ins) == 3
        return _idprefix + ins + idrandoms[0]
    if idrandoms[useragentidnb]:
        return idrandoms[useragentidnb]
    return ''

def updateIdRandoms(idrandoms):
    for i in xrange(4):
        if idrandoms[i] is not None:
            _idrandoms[i] = idrandoms[i]

def getIdRandoms():
    return _idrandoms[:]
