# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from time import clock


class Measure:
    def __init__(self, window, start = None, last = None, rate = 0.0):
        now = clock()
        self.window = window
        if start is None:
            self.start = now
        else:
            self.start = start
        if last is None:
            self.last = now
        else:
            self.last = last
        self.rate = rate
        self.total = 0L

    def update_rate(self, amount):
        now = clock()
        self.rate = (self.rate * max(self.last - max(now - self.window, self.start), 0.) + amount) / min(self.window, now - self.start)
        self.total += amount
        self.last = now
        return self.rate

    def get_rate(self):
        now = clock()
        return self.rate * max(self.last - max(now - self.window, self.start), 0.) / min(self.window, now - self.start)

    def get_lastrate(self):
        # Useful for pulsating signals
        if self.last <= max(clock() - self.window, self.start):
            return 0.
        return self.rate

    def get_total(self):
        return self.total

    def setWindow(self, window):
        self.window = window

    def reset(self):
        self.rate = 0.0
