# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from time import clock

from BitTornado.CurrentRateMeasure import Measure
from BitTornado.buffer import PIECEREADBUFFERPOOL, newDataBuffer


class Upload:
    def __init__(self, connection, ratelimiter, choker, storage,
                 picker, piecereadbufferlength, config, sched):
        self.connection = connection
        self.ratelimiter = ratelimiter
        self.choker = choker
        self.storage = storage
        self.picker = picker
        self.piecereadbufferlength = piecereadbufferlength
        self.config = config
        self.sched = sched
        self.max_slice_length = config['max_slice_length']
        self.choked = True
        self.cleared = True
        self.interested = False
        self.super_seeding = False
        self.buffer = []
        self.measure = Measure(config['max_rate_period'])
        self.was_ever_interested = False
        if not self.config['magnet']:
            if storage.get_amount_left() == 0:
                if choker.super_seed:
                    self.super_seeding = True   # flag, and don't send bitfield
                    self.seed_have_list = []    # set from piecepicker
                    self.skipped_count = 0
                elif config['breakup_seed_bitfield']:
                    bitfield, msgs = storage.get_have_list_cloaked()
                    connection.send_bitfield(bitfield)
                    for have in msgs:
                        connection.send_have(have)
                else:
                    connection.send_bitfield(storage.get_have_list())
            elif storage.do_I_have_anything():
                connection.send_bitfield(storage.get_have_list())
        self.piecedl = None
        self.piecebuf = None
        self.piecebuflastaccess = 0.
        self.read_buffer_expiration = config['read_buffer_expiration']
        self.read_buf_max = long(config['read_buffer_size'] * 1048576)
        self.piecebufstartindex = 0L

    def updateData(self):
        if self.storage.get_amount_left() == 0:
            if self.choker.super_seed:
                self.super_seeding = True   # flag, and don't send bitfield
                self.seed_have_list = []    # set from piecepicker
                self.skipped_count = 0
            elif self.config['breakup_seed_bitfield']:
                bitfield, msgs = self.storage.get_have_list_cloaked()
                self.connection.send_bitfield(bitfield)
                for have in msgs:
                    self.connection.send_have(have)
            else:
                self.connection.send_bitfield(self.storage.get_have_list())
        elif self.storage.do_I_have_anything():
            self.connection.send_bitfield(self.storage.get_have_list())

    def setReadBufferSize(self, readbuffersize):
        self.read_buf_max = long(readbuffersize * 1048576)
        if self.piecebuf is not None:
            self.piecebuf.release()
            self.piecebuf = None

    def got_not_interested(self):
        if self.interested:
            self.interested = False
            del self.buffer[:]
            if self.piecebuf is not None:
                self.piecebuf.release()
                self.piecebuf = None
            self.choker.not_interested(self.connection)

    def got_interested(self):
        if not self.interested:
            self.interested = True
            self.was_ever_interested = True
            self.choker.interested(self.connection)

    def get_upload_chunk(self):
        if self.choked or not self.buffer:
            return None
        index, begin, length = self.buffer.pop(0)
        piece = newDataBuffer(13 * ' ', size = 13 + length)
        err = ''

        if self.read_buf_max:
            # Piece will be buffered into blocks of max size read_buf_max
            piecebufstartindex = (begin / self.read_buf_max) * self.read_buf_max
            # Init piecebuf if necessary
            if self.piecebuf is None or index != self.piecedl or piecebufstartindex != self.piecebufstartindex:
                self.piecebufstartindex = piecebufstartindex
                if self.piecebuf is not None:
                    self.piecebuf.release()
                self.piecebuf, err = self.storage.get_piece(index, self.piecebufstartindex,
                                                            min(self.storage._piecelen(index) - self.piecebufstartindex, self.read_buf_max),
                                                            checkoverload = True)
            if self.piecebuf is not None:
                while True:
                    piece.append(self.piecebuf.viewSlice(max(begin - self.piecebufstartindex, 0),
                                                         min(begin + length - self.piecebufstartindex, self.read_buf_max)))
                    if len(piece) - 13 == length:
                        self.piecebuflastaccess = clock()
                        break
                    self.piecebufstartindex += self.read_buf_max
                    self.piecebuf.release()
                    self.piecebuf, err = self.storage.get_piece(index, self.piecebufstartindex,
                                                                min(self.storage._piecelen(index) - self.piecebufstartindex, self.read_buf_max),
                                                                checkoverload = True)
                    if self.piecebuf is None:
                        break

        if self.piecebuf is None:
            if err:
                piece.setLength(13)
            # Read part of piece from disc
            self.storage.get_piece(index, begin, length, buf = piece)
        else:
            self.piecedl = index

        return (index, begin, piece)

    def got_request(self, index, begin, length):
        if ((self.super_seeding and not index in self.seed_have_list)
            or not self.interested or length > self.max_slice_length):
            self.connection.close()
            return
        if not self.cleared:
            self.buffer.append((index, begin, length))
        if not self.choked and self.connection.next_upload is None \
           and not self.connection.backlogged():
            self.ratelimiter.queue(self.connection)

    def got_cancel(self, index, begin, length):
        try:
            self.buffer.remove((index, begin, length))
            return
        except ValueError:
            pass

    def choke(self):
        if not self.choked:
            self.choked = True
            self.connection.send_choke()
        # if self.piecebuf is not None:
            # self.piecebuf.release()
            # self.piecebuf = None

    def choke_sent(self):
        del self.buffer[:]
        self.cleared = True

    def unchoke(self):
        if self.choked:
            if self.config['read_buffer_memory_saving'] == 0 \
               and PIECEREADBUFFERPOOL.isOverloaded(self.piecereadbufferlength):
                return
            self.choked = False
            self.cleared = False
            self.connection.send_unchoke()

    def disconnected(self):
        if self.piecebuf is not None:
            self.piecebuf.release()
            self.piecebuf = None

    def is_choked(self):
        return self.choked

    def is_interested(self):
        return self.interested

    def has_queries(self):
        return not self.choked and self.buffer

    def get_rate(self):
        return self.measure.get_rate()

    def expirePieceBuffer(self):
        if self.piecebuf is not None and clock() - self.piecebuflastaccess > self.read_buffer_expiration:
            self.piecebuf.release()
            self.piecebuf = None
