# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from BitTornado.bitfield import Bitfield
from BitTornado.utility import exceptionArgsToString, getABCUtility
from hashlib import sha1
from time import clock, sleep
from random import randrange
from threading import Thread, Lock, Event
from ctypes import windll, c_long, c_wchar_p, byref, GetLastError
try:
    from bisect import insort
except:
    def insort(l, item):
        l.append(item)
        l.sort()

DEBUG = False

STATS_INTERVAL = 1


class Olist:
    def __init__(self, l = []):
        self.d = {}
        for i in l:
            self.d[i] = 1

    def __len__(self):
        return len(self.d)

    def includes(self, i):
        return self.d.has_key(i)

    def add(self, i):
        self.d[i] = 1

    def extend(self, l):
        for i in l:
            self.d[i] = 1

    def pop(self, n = 0):
        # assert self.d
        k = self.d.keys()
        if n == 0:
            i = min(k)
        elif n == -1:
            i = max(k)
        else:
            k.sort()
            i = k[n]
        del self.d[i]
        return i

    def remove(self, i):
        if self.d.has_key(i):
            del self.d[i]


class StorageWrapper:
    def __init__(self, storage, picker, request_size, hashes,
            piece_length, files, onlycheck, finished,
            failed, flag, unpauseflag,
            sem, infohash, startqueue,
            check_hashes = True, data_flunked = lambda x: None,
            sched = None, config = {}, endallocfunc = None,
            checkfreediskspacefunc = None, updatetorrentdatafunc = None,
            displayongoingfunc = None):
        self.storage = storage
        self.picker = picker
        self.request_size = long(request_size)
        self.hashes = hashes
        self.piece_length = long(piece_length)
        start = 0L
        self.filepieces = []
        for i in xrange(len(files)):
            l = files[i][1]
            self.filepieces.append((int(start / self.piece_length), int((start + l - 1) / self.piece_length)))
            start += l
        self.receivedpieces = [0] * len(files)
        self.finished = finished
        self.failed = failed
        self.flag = flag
        self.check_hashes = check_hashes
        self.data_flunked = data_flunked
        self.sched = sched
        self.config = config
        self.unpauseflag = unpauseflag
        self.sem = sem
        self.infohash = infohash
        self.startqueue = startqueue
        self.endallocfunc = endallocfunc
        self.checkfreediskspacefunc = checkfreediskspacefunc
        self.updatetorrentdatafunc = updatetorrentdatafunc
        self.displayongoingfunc = displayongoingfunc
        self.alloc_type = config.get('alloc_type', 'normal')
        if config.get('alloc_rate', 0) < 0.1:
            config['alloc_rate'] = 0.1
        self.alloc_delay = float(self.piece_length) / (config['alloc_rate'] * 1048576)
        self.double_check = config.get('double_check', 0)
        self.triple_check = config.get('triple_check', 0)
        if self.triple_check:
            self.double_check = True
        self.bgalloc_enabled = False
        self.bgalloc_active = True
        self.alloc_buf = getABCUtility().allocbuf
        self.alloc_buf_length = len(self.alloc_buf)
        self.total_length = storage.get_total_length()
        self.lastpiece = len(hashes) - 1
        self.lastpiece_length = self.total_length - (self.lastpiece * self.piece_length)
        lastpiecefrac = float(self.lastpiece_length) / self.piece_length
        self.lastpieceremainfrac = 1 - lastpiecefrac
        self.piecenumberfrac = len(hashes) - self.lastpieceremainfrac
        self.picker.initPieceFrac(lastpiecefrac)
        self.alloc_buf_div, self.alloc_buf_mod = divmod(self.piece_length, self.alloc_buf_length)
        self.alloc_buf_div *= self.alloc_buf_length
        self.amount_left = self.total_length
        if self.total_length:
            if self.total_length <= self.piece_length * (self.lastpiece):
                raise ValueError, getABCUtility().lang.get('responsetoosmall')
            if self.total_length > self.piece_length * len(hashes):
                raise ValueError, getABCUtility().lang.get('responsetoobig')
        self.numactive = [0] * len(hashes)
        self.inactive_requests = [1] * len(hashes)
        self.amount_inactive = self.total_length
        self.amount_obtained = 0
        self.amount_desired = self.total_length
        self.have = Bitfield(len(hashes))
        self.have_cloaked_data = None
        self.blocked = Bitfield(len(hashes))
        self.blocked_holes = []
        self.blocked_movein = Olist()
        self.blocked_moveout = Olist()
        self.waschecked = Bitfield(len(hashes))
        self.places = {}
        self.holes = []
        self.stat_active = {}
        self.stat_new = {}
        self.dirty = {}
        self.stat_numflunked = 0
        self.stat_numdownloaded = 0
        self.stat_numfound = 0
        self.piece_history = {}
        # self.out_of_place = 0
        self.write_buf_max = long(config['write_buffer_size'] * 1048576)
        self.check_buf_max = long(config['check_buffer_size'] * 1048576)
        self.write_buf_size = 0L
        self.write_buf = {}   # structure:  piece: [(start, data), ...]
        self.write_buf_list = []
        self.lastwrite = 0.
        self.write_buffer_expiration = config['write_buffer_expiration']
        self.finishallocrequest = False
        self.checkpiecebeforeupload = config['check_piece_before_upload']
        self.initfilesdone = False

        if config['magnet']:
            self.initialize_tasks = []
        else:
            self.initialize_tasks = [('checkingexistingdata1', self.init_hashcheck, 'checkingexistingdata2', self.hashcheckfunc)]
            if not onlycheck:
                self.initialize_tasks.extend([('movingdata1', self.init_movedata, 'movingdata2', self.movedatafunc),
                                              ('allocatingdiskspace1', self.init_alloc, 'allocatingdiskspace2', self.allocfunc)])
                if self.alloc_type == 'background' or self.alloc_type == 'normal':
                    self.sched(self._bgalloc, 0.1)
                #self.sched(self._bgsync, max(config['auto_flush'] * 60, 60))
                self.sched(self.flushWriteBuffer, self.write_buffer_expiration)

    def updateData(self, hashes, piece_length, files):
        self.hashes = hashes
        self.piece_length = long(piece_length)
        start = 0L
        self.filepieces = []
        for i in xrange(len(files)):
            l = files[i][1]
            self.filepieces.append((int(start / self.piece_length), int((start + l - 1) / self.piece_length)))
            start += l
        self.receivedpieces = [0] * len(files)
        self.alloc_delay = float(self.piece_length) / (self.config['alloc_rate'] * 1048576)
        self.total_length = self.storage.get_total_length()
        self.lastpiece = len(hashes) - 1
        self.lastpiece_length = self.total_length - (self.lastpiece * self.piece_length)
        lastpiecefrac = float(self.lastpiece_length) / self.piece_length
        self.lastpieceremainfrac = 1 - lastpiecefrac
        self.piecenumberfrac = len(hashes) - self.lastpieceremainfrac
        self.picker.initPieceFrac(lastpiecefrac)
        self.alloc_buf_div, self.alloc_buf_mod = divmod(self.piece_length, self.alloc_buf_length)
        self.alloc_buf_div *= self.alloc_buf_length
        self.amount_left = self.total_length
        if self.total_length:
            if self.total_length <= self.piece_length * (self.lastpiece):
                raise ValueError, getABCUtility().lang.get('responsetoosmall')
            if self.total_length > self.piece_length * len(hashes):
                raise ValueError, getABCUtility().lang.get('responsetoobig')
        self.numactive = [0] * len(hashes)
        self.inactive_requests = [1] * len(hashes)
        self.amount_inactive = self.total_length
        self.amount_obtained = 0
        self.amount_desired = self.total_length
        self.have = Bitfield(len(hashes))
        self.have_cloaked_data = None
        self.blocked = Bitfield(len(hashes))
        self.blocked_holes = []
        self.blocked_movein = Olist()
        self.blocked_moveout = Olist()
        self.waschecked = Bitfield(len(hashes))
        self.places = {}
        self.holes = []
        self.stat_active = {}
        self.stat_new = {}
        self.dirty = {}
        self.stat_numflunked = 0
        self.stat_numdownloaded = 0
        self.stat_numfound = 0
        self.piece_history = {}
        # self.out_of_place = 0
        self.write_buf_size = 0L
        self.write_buf = {}   # structure:  piece: [(start, data), ...]
        self.write_buf_list = []
        self.lastwrite = 0.
        self.initialize_tasks = [('checkingexistingdata1', self.init_hashcheck, 'checkingexistingdata2', self.hashcheckfunc),
                                 ('movingdata1', self.init_movedata, 'movingdata2', self.movedatafunc),
                                 ('allocatingdiskspace1', self.init_alloc, 'allocatingdiskspace2', self.allocfunc)]

    def updateReceivedPieces(self, piece):
        p = 0
        for r in self.filepieces:
            if piece < r[0]:
                break
            if piece <= r[1]:
                self.receivedpieces[p] += 1
            p += 1

    def setWriteBufferSize(self, writebuffersize):
        self.write_buf_max = long(writebuffersize * 1048576)

    def flushWriteBuffer(self):
        if self.write_buf_list and clock() - self.lastwrite > self.write_buffer_expiration:
            while self.write_buf_list:
                self._flush_buffer(self.write_buf_list.pop(), True)
        self.sched(self.flushWriteBuffer, 10)

    #def _bgsync(self):
    #    if self.config['auto_flush']:
    #        self.sync()
    #    self.sched(self._bgsync, max(self.config['auto_flush'] * 60, 60))

    def old_style_init(self, statusfunc, reset = False):
        self.statusfunc = statusfunc
        while self.initialize_tasks:
            msg_init, _init, msg_next, _next = self.initialize_tasks.pop(0)
            if msg_init == 'movingdata1':
                if self.alloc_type == 'sparse1':
                    ongoing = True
                elif self.alloc_type == 'sparse2':
                    ongoing = ''
                else:
                    ongoing = None
            else:
                ongoing = None
            if msg_init != 'allocatingdiskspace1' or (self.alloc_type != 'sparse1' and self.alloc_type != 'sparse2'):
                self.statusfunc(activity = msg_init, fractionDone = 0, ongoing = ongoing)
            initresult = _init()
            if initresult:
                self.statusfunc(activity = msg_next, fractionDone = 0.)
                t = 0.
                x = 0.
                while x is not None:
                    now = clock()
                    if t < now:
                        t = now + STATS_INTERVAL
                        self.statusfunc(activity = msg_next, fractionDone = x)
                    if not self.unpauseflag.isSet():
                        self.sem.release()
                        while not self.unpauseflag.isSet():
                            if self.flag.isSet():
                                # semaphore is not acquired
                                return None
                            sleep(.2)
                        self.statusfunc(activity = 'waiting', fractionDone = x)
                        # Re-acquire semaphore
                        self.startqueue.append(self.infohash)
                        while self.infohash != self.startqueue[0] or not self.sem.acquire(False):
                            if self.flag.isSet():
                                self.startqueue.remove(self.infohash)
                                # semaphore is not acquired
                                return None
                            if not self.unpauseflag.isSet():
                                self.startqueue.remove(self.infohash)
                                while not self.unpauseflag.isSet():
                                    if self.flag.isSet():
                                        # semaphore is not acquired
                                        return None
                                    sleep(.2)
                                self.statusfunc(activity = 'waiting', fractionDone = x)
                                self.startqueue.append(self.infohash)
                            sleep(.1)
                        del self.startqueue[0]
                    if self.flag.isSet():
                        # semaphore is acquired
                        return False
                    x = _next()
                    if self.flag.isSet():
                        # semaphore is acquired
                        return False
            elif self.flag.isSet():
                # None if semaphore not acquired, else False
                return initresult
        if reset:
            if self.alloc_type == 'background' or self.alloc_type == 'normal':
                self.sched(self._bgalloc, 0.1)
            #self.sched(self._bgsync, max(self.config['auto_flush'] * 60, 60))
            self.sched(self.flushWriteBuffer, self.write_buffer_expiration)
        if reset or not self.config['magnet']:
            self.initfilesdone = True
            self.storage.startScanForHandleTimeout()
        return True

    def init_hashcheck(self):
        if self.flag.isSet():
            return False
        self.check_list = []
        if not self.hashes or self.amount_left == 0:
            self.check_total = 0
            self.updatetorrentdatafunc()
            self.finished()
            return False

        self.check_targets = {}
        got = {}
        for p, v in self.places.items():
            assert not got.has_key(v)
            got[v] = 1
        for i in xrange(len(self.hashes)):
            if self.places.has_key(i):  # restored from pickled
                self.check_targets[self.hashes[i]] = []
                if self.places[i] == i:
                    continue
                assert not got.has_key(i)
                # self.out_of_place += 1
            if got.has_key(i):
                continue
            if self._waspre(i):
                if self.blocked[i]:
                    self.places[i] = i
                else:
                    self.check_list.append(i)
                continue
            if not self.check_hashes:
                self.failed(getABCUtility().lang.get('missingdatacomplete'))
                return False
            self.holes.append(i)
            if self.blocked[i] or self.check_targets.has_key(self.hashes[i]):
                self.check_targets[self.hashes[i]] = [] # in case of a hash collision, discard
            else:
                self.check_targets[self.hashes[i]] = [i]
        self.check_total = len(self.check_list)
        self.check_numchecked = 0.0
        self.numchecked = 0.0
        return self.check_total > 0

    def _markgot(self, piece, pos):
        if DEBUG:
            print piece, 'at', pos
        self.places[piece] = pos
        self.have[piece] = True
        self.updateReceivedPieces(piece)
        length = self._piecelen(piece)
        self.amount_obtained += length
        self.amount_left -= length
        self.amount_inactive -= length
        self.inactive_requests[piece] = None
        self.waschecked[piece] = self.check_hashes
        self.stat_numfound += 1

    def hashcheckfunc(self):
        if self.flag.isSet():
            return None
        if not self.check_list:
            if self.amount_left == 0:
                self.updatetorrentdatafunc()
                self.finished()
            return None
        i = self.check_list.pop(0)
        if not self.check_hashes:
            self._markgot(i, i)
        else:
            ###############################################################
            # d = self.read_raw(i, 0, self.lastpiece_length)
            # sh = sha1(d.viewSlice())
            # d.release()
            # sp = sh.digest()
            # d = self.read_raw(i, self.lastpiece_length, self._piecelen(i) - self.lastpiece_length)
            # sh.update(d.viewSlice())
            # d.release()
            ###############################################################
            # buf_div, buf_mod = divmod(self.lastpiece_length, self.check_buf_max)
            # buf_div *= self.check_buf_max
            # sh = sha1()
            # for s in xrange(0, buf_div, self.check_buf_max):
                # d = self.read_raw(i, s, self.check_buf_max)
                # sh.update(d.viewSlice())
                # d.release()
            # if buf_mod:
                # d = self.read_raw(i, buf_div, buf_mod)
                # sh.update(d.viewSlice())
                # d.release()
            # sp = sh.digest()
            # buf_div, buf_mod = divmod(self._piecelen(i) - self.lastpiece_length, self.check_buf_max)
            # buf_div = self.lastpiece_length + buf_div * self.check_buf_max
            # for s in xrange(self.lastpiece_length, buf_div, self.check_buf_max):
                # d = self.read_raw(i, s, self.check_buf_max)
                # sh.update(d.viewSlice())
                # d.release()
            # if buf_mod:
                # d = self.read_raw(i, buf_div, buf_mod)
                # sh.update(d.viewSlice())
                # d.release()
            ###############################################################
            pos = 0
            end = self.lastpiece_length
            sh = sha1()
            d = None
            while pos < end:
                length = min(end - pos, self.check_buf_max)
                d = self.read_raw(i, pos, length, buf = d)
                sh.update(d.viewSlice())
                d.setLength(0)
                pos += length
            if d is not None:
                d.release()
            sp = sh.digest()
            pos = self.lastpiece_length
            end = self._piecelen(i)
            d = None
            while pos < end:
                length = min(end - pos, self.check_buf_max)
                d = self.read_raw(i, pos, length, buf = d)
                sh.update(d.viewSlice())
                d.setLength(0)
                pos += length
            if d is not None:
                d.release()
            ###############################################################
            s = sh.digest()
            if s == self.hashes[i]:
                self._markgot(i, i)
            elif self.check_targets.get(s) and self._piecelen(i) == self._piecelen(self.check_targets[s][-1]):
                self._markgot(self.check_targets[s].pop(), i)
                # self.out_of_place += 1
            elif not self.have[-1] and sp == self.hashes[-1] \
                 and (i == self.lastpiece or not self._waspre(self.lastpiece)):
                self._markgot(self.lastpiece, i)
                # if i != self.lastpiece:
                    # self.out_of_place += 1
            else:
                self.places[i] = i
        self.numchecked += 1
        return (self.numchecked / self.check_total)

    def init_movedata(self):
        if self.flag.isSet():
            return False
        if not self.hashes or self.amount_left == 0:
            return False
        if self.alloc_type == 'sparse1' or self.alloc_type == 'sparse2':
            if self.alloc_type == 'sparse1':
                topoffval = '\xFF'
            else:
                topoffval = '\x00'
            allocationperfile = self.storage.toBeAllocated(topoffval)
            totaltobeallocated = 0.
            for apf in allocationperfile:
                if apf[1] != apf[2]:
                    # If a file has been partially allocated,
                    # switch to pre-allocate because sparse allocation resets the whole file,
                    # erasing data already downloaded
                    self.alloc_type = 'pre-allocate'
                    return False
                totaltobeallocated += apf[2]
            if self.alloc_type == 'sparse1':
                endtopofflock = Lock()
                endtopoffflag = Event()
                synctopoffflag = Event()
        else:
            return False

        allocated = 0L
        fractiondone = 0.
        t = 0.
        # To make '!' blink 
        ongoingblink = True
        for i in xrange(len(allocationperfile)):
            tobeallocated = allocationperfile[i][2]
            if not self.checkfreediskspacefunc(tobeallocated):
                # Wait for the torrent to be queued back by the disk full watchdog
                self.flag.wait()
                return False
            if topoffval == '\xFF':
                if self.flag.isSet():
                    return False
                if not self.unpauseflag.isSet():
                    self.sem.release()
                    self.statusfunc(activity = 'waiting', fractionDone = fractiondone, ongoing = True)
                    while not self.unpauseflag.isSet():
                        if self.flag.isSet():
                            # return with semaphore not acquired
                            return None
                        sleep(.2)
                    # Re-acquire semaphore
                    self.startqueue.append(self.infohash)
                    while self.infohash != self.startqueue[0] or not self.sem.acquire(False):
                        if self.flag.isSet():
                            self.startqueue.remove(self.infohash)
                            # return with semaphore not acquired
                            return None
                        if not self.unpauseflag.isSet():
                            self.startqueue.remove(self.infohash)
                            while not self.unpauseflag.isSet():
                                if self.flag.isSet():
                                    # return with semaphore not acquired
                                    return None
                                sleep(.2)
                            self.statusfunc(activity = 'waiting', fractionDone = fractiondone, ongoing = True)
                            self.startqueue.append(self.infohash)
                        sleep(.1)
                    del self.startqueue[0]
                    ongoingblink = True
                    t = 0.
                now = clock()
                if t < now:
                    t = now + STATS_INTERVAL
                    self.statusfunc(activity = 'movingdata1', fractionDone = fractiondone, ongoing = ongoingblink)
                    ongoingblink = not ongoingblink
                Thread(target = self.storage.top_off, args = [i, endtopofflock, endtopoffflag, synctopoffflag, self.sem]).start()
                while not endtopoffflag.isSet():
                    if not self.unpauseflag.isSet():
                        semisreleased = False
                        while not self.unpauseflag.isSet():
                            if self.flag.isSet():
                                if not semisreleased:
                                    # Ask topoff thread to release semaphore when current file is allocated
                                    self.storage.releasesem = True
                                    synctopoffflag.set()
                                    self.displayongoingfunc(endtopoffflag)
                                # return with semaphore not acquired
                                return None
                            # release sem only if current file allocation is over
                            synctopoffflag.set()
                            with endtopofflock:
                                synctopoffflag.clear()
                            if endtopoffflag.isSet():
                                if not semisreleased:
                                    self.sem.release()
                                    semisreleased = True
                                    fractiondone = (allocated + tobeallocated) / totaltobeallocated
                                    self.statusfunc(activity = 'waiting', fractionDone = fractiondone, ongoing = True)
                            else:
                                now = clock()
                                if t < now:
                                    t = now + STATS_INTERVAL
                                    self.statusfunc(activity = 'movingdata1',
                                                    fractionDone = (allocated + self.getSparseSize(allocationperfile[i][0])) / totaltobeallocated,
                                                    ongoing = ongoingblink)
                                    ongoingblink = not ongoingblink
                            sleep(.2)
                        if semisreleased:
                            # Re-acquire semaphore
                            self.statusfunc(activity = 'waiting', fractionDone = fractiondone, ongoing = True)
                            self.startqueue.append(self.infohash)
                            while self.infohash != self.startqueue[0] or not self.sem.acquire(False):
                                if self.flag.isSet():
                                    self.startqueue.remove(self.infohash)
                                    # return with semaphore not acquired
                                    return None
                                if not self.unpauseflag.isSet():
                                    self.startqueue.remove(self.infohash)
                                    while not self.unpauseflag.isSet():
                                        if self.flag.isSet():
                                            # return with semaphore not acquired
                                            return None
                                        sleep(.2)
                                    self.statusfunc(activity = 'waiting', fractionDone = fractiondone, ongoing = True)
                                    self.startqueue.append(self.infohash)
                                sleep(.1)
                            del self.startqueue[0]
                            ongoingblink = True
                            t = 0.
                    if self.flag.isSet():
                        # Ask topoff thread to release semaphore when current file is allocated
                        self.storage.releasesem = True
                        synctopoffflag.set()
                        self.displayongoingfunc(endtopoffflag)
                        # return with semaphore not acquired
                        return None
                    synctopoffflag.set()
                    with endtopofflock:
                        synctopoffflag.clear()
                    now = clock()
                    if t < now:
                        t = now + STATS_INTERVAL
                        self.statusfunc(activity = 'movingdata1',
                                        fractionDone = (allocated + self.getSparseSize(allocationperfile[i][0])) / totaltobeallocated,
                                        ongoing = ongoingblink)
                        ongoingblink = not ongoingblink
                    sleep(.001)
                allocated += tobeallocated
                fractiondone = allocated / totaltobeallocated
                endtopoffflag.clear()
            else:
                self.storage.top_off(i)
        if topoffval == '\xFF':
            self.statusfunc(activity = 'movingdata1', fractionDone = 1., ongoing = True)
        else:
            self.statusfunc(activity = 'movingdata1', fractionDone = 1., ongoing = '')

        ##############################################
        # Original code
        # Changing file priorities fails for a running torrent
        # self.movelist = []
        # if self.out_of_place == 0:
            # for i in self.holes:
                # self.places[i] = i
            # self.holes = []
            # return False
        # self.tomove = float(self.out_of_place)
        # for i in xrange(len(self.hashes)):
            # if not self.places.has_key(i):
                # self.places[i] = i
            # elif self.places[i] != i:
                # self.movelist.append(i)
        ##############################################
        self.movelist = []
        for i in self.holes:
            if self.blocked[i]:
                self.blocked_holes.append(i)
        for i in xrange(len(self.hashes)):
            if not self.places.has_key(i):
                self.places[i] = i
            elif self.places[i] != i:
                self.movelist.append(i)
        self.out_of_place = float(len(self.movelist))
        ##############################################

        self.holes = []
        return self.out_of_place > 0

    def movedatafunc(self):
        if self.flag.isSet():
            return None
        if not self.movelist:
            return None
        i = self.movelist.pop(0)
        ###############################################################
        # old = self.read_raw(self.places[i], 0, self._piecelen(i))
        # self.write_raw(i, 0, old)
        # if self.double_check and self.have[i]:
            # if self.triple_check:
                # old.release()
                # old = self.read_raw(i, 0, self._piecelen(i), flush_first = True)
            # if sha1(old.viewSlice()).digest() != self.hashes[i]:
                # old.release()
                # self.failed(getABCUtility().lang.get('corrupteddownload'))
                # return None
        # old.release()
        ###############################################################
        # buf_div, buf_mod = divmod(self._piecelen(i), self.check_buf_max)
        # buf_div *= self.check_buf_max
        # if self.double_check and self.have[i]:
            # sh = sha1()
        # for s in xrange(0, buf_div, self.check_buf_max):
            # old = self.read_raw(self.places[i], s, self.check_buf_max)
            # self.write_raw(i, s, old)
            # if self.double_check and self.have[i]:
                # if self.triple_check:
                    # old.release()
                    # old = self.read_raw(i, s, self.check_buf_max, flush_first = True)
                # sh.update(old.viewSlice())
            # old.release()
        # if buf_mod:
            # old = self.read_raw(self.places[i], buf_div, buf_mod)
            # self.write_raw(i, buf_div, old)
            # if self.double_check and self.have[i]:
                # if self.triple_check:
                    # old.release()
                    # old = self.read_raw(i, buf_div, buf_mod, flush_first = True)
                # sh.update(old.viewSlice())
            # old.release()
        
        # if self.double_check and self.have[i] and sh.digest() != self.hashes[i]:
            # self.failed(getABCUtility().lang.get('corrupteddownload'))
            # return None
        ###############################################################
        pos = 0
        end = self._piecelen(i)
        old = None
        if self.double_check and self.have[i]:
            sh = sha1()
        while pos < end:
            length = min(end - pos, self.check_buf_max)
            old = self.read_raw(self.places[i], pos, length, buf = old)
            self.write_raw(i, pos, old.viewSlice())
            if self.double_check and self.have[i]:
                if self.triple_check:
                    old.setLength(0)
                    old = self.read_raw(i, pos, length, flush_first = True, buf = old)
                sh.update(old.viewSlice())
            old.setLength(0)
            pos += length
        if old is not None:
            old.release()

        if self.double_check and self.have[i] and sh.digest() != self.hashes[i]:
            self.failed(getABCUtility().lang.get('corrupteddownload'))
            return None
        ###############################################################

        self.places[i] = i
        return (self.out_of_place - len(self.movelist)) / self.out_of_place

    def init_alloc(self):
        if self.flag.isSet():
            return False
        if not self.holes:
            return False
        self.numholes = float(len(self.holes))
        if self.alloc_type == 'pre-allocate':
            self.bgalloc_enabled = True
            return True
        if self.alloc_type == 'background':
            self.bgalloc_enabled = True
        if self.blocked_moveout:
            return True
        return False

    def alloc_piece(self, piece):
        if not self.checkfreediskspacefunc(self._piecelen(piece)):
            # Wait for the torrent to be queued back by the disk full watchdog
            self.flag.wait()
            return None
        if piece < self.lastpiece:
            for s in xrange(0, self.alloc_buf_div, self.alloc_buf_length):
                self.write_raw(piece, s, self.alloc_buf)
            if self.alloc_buf_mod:
                self.write_raw(piece, self.alloc_buf_div, self.alloc_buf[:self.alloc_buf_mod])
        else:
            alloc_buf_div, alloc_buf_mod = divmod(self.lastpiece_length, self.alloc_buf_length)
            alloc_buf_div *= self.alloc_buf_length
            for s in xrange(0, alloc_buf_div, self.alloc_buf_length):
                self.write_raw(piece, s, self.alloc_buf)
            if alloc_buf_mod:
                self.write_raw(piece, alloc_buf_div, self.alloc_buf[:alloc_buf_mod])
        return True
    
    def _allocfunc(self):
        while self.holes:
            n = self.holes.pop(0)
            if self.blocked[n]: # assume not self.blocked[index]
                if not self.blocked_movein:
                    self.blocked_holes.append(n)
                    continue
                if not self.places.has_key(n):
                    b = self.blocked_movein.pop(0)
                    oldpos = self._move_piece(b, n)
                    self.places[oldpos] = oldpos
                    return None
            if self.places.has_key(n):
                oldpos = self._move_piece(n, n)
                self.places[oldpos] = oldpos
                return None
            return n
        return None

    def allocfunc(self):
        if self.flag.isSet():
            return None

        if self.blocked_moveout:
            self.bgalloc_active = True
            n = self._allocfunc()
            if n is not None:
                if self.blocked_moveout.includes(n):
                    self.blocked_moveout.remove(n)
                    b = n
                else:
                    b = self.blocked_moveout.pop(0)
                oldpos = self._move_piece(b, n)
                self.places[oldpos] = oldpos
            return (self.numholes - len(self.holes)) / self.numholes

        if self.holes and self.bgalloc_enabled:
            self.bgalloc_active = True
            n = self._allocfunc()
            if n is not None:
                if not self.alloc_piece(n):
                    return None
                self.places[n] = n
            return (self.numholes - len(self.holes)) / self.numholes

        if self.bgalloc_active:
            self.bgalloc_active = False
            if self.bgalloc_enabled:
                self.endallocfunc()

        if self.finishallocrequest:
            self.endallocfunc(onrequest = True)
            self.finishallocrequest = False

        return None

    def bgalloc(self):
        if self.alloc_type == 'sparse1' or self.alloc_type == 'sparse2' or self.alloc_type == 'pre-allocate':
            if self.initfilesdone:
                self.endallocfunc(onrequest = True)
        else:
            self.sched(self.finishalloc)

    def finishalloc(self):
        self.bgalloc_enabled = True
        self.finishallocrequest = True

    def _bgalloc(self):
        self.allocfunc()
        if self.flag.isSet():
            return None
        self.sched(self._bgalloc, self.alloc_delay)

    def getSparseSize(self, filename):
        hi_dword = c_long()
        lo_dword = windll.kernel32.GetCompressedFileSizeW(c_wchar_p(filename), byref(hi_dword))
        # lo_dword and hi_dword are returned as signed
        if lo_dword != -1 or GetLastError() == 0:
            if lo_dword < 0:
                lo_dword += 4294967296
            if hi_dword.value < 0:
                return lo_dword + (hi_dword.value + 4294967296) * 0x100000000
            return lo_dword + hi_dword.value * 0x100000000
        return 0

    def _waspre(self, piece):
        return self.storage.was_preallocated(piece * self.piece_length, self._piecelen(piece))

    def _piecelen(self, piece):
        if piece < self.lastpiece:
            return self.piece_length
        return self.lastpiece_length

    def get_amount_left(self):
        return self.amount_left

    def do_I_have_anything(self):
        return self.amount_left < self.total_length

    def _make_inactive(self, index):
        length = self._piecelen(index)
        l = []
        x = 0
        while x + self.request_size < length:
            l.append((x, self.request_size))
            x += self.request_size
        l.append((x, length - x))
        self.inactive_requests[index] = l

    def is_endgame(self):
        if self.config['magnet']:
            return False
        return not self.amount_inactive

    def am_I_complete(self):
        if self.config['magnet']:
            return False
        return self.amount_obtained == self.amount_desired

    def reset_endgame(self, requestlist):
        for index, begin, length in requestlist:
            self.request_lost(index, begin, length)

    def get_have_list(self):
        return self.have.tostring()

    def get_have_list_cloaked(self):
        if self.have_cloaked_data is None:
            newhave = Bitfield(copyfrom = self.have)
            unhaves = []
            n = min(randrange(2, 5), len(self.hashes))    # between 2-4 unless torrent is small
            while len(unhaves) < n:
                unhave = randrange(min(32, len(self.hashes)))    # all in first 4 bytes
                if not unhave in unhaves:
                    unhaves.append(unhave)
                    newhave[unhave] = False
            self.have_cloaked_data = (newhave.tostring(), unhaves)
        return self.have_cloaked_data

    def do_I_have(self, index):
        return self.have[index]

    def do_I_have_requests(self, index):
        return not not self.inactive_requests[index]

    def is_unstarted(self, index):
        return (not self.have[index] and not self.numactive[index]
                and not self.dirty.has_key(index))

    def get_hash(self, index):
        return self.hashes[index]

    def get_stats(self):
        return max(self.amount_obtained, 0), self.amount_desired

    def new_request(self, index):
        if self.inactive_requests[index] == 1:
            self._make_inactive(index)
        self.numactive[index] += 1
        self.stat_active[index] = 1
        if not self.dirty.has_key(index):
            self.stat_new[index] = 1
        rs = self.inactive_requests[index]
#        r = min(rs)
#        rs.remove(r)
        r = rs.pop(0)
        self.amount_inactive -= r[1]
        return r

    def write_raw(self, index, begin, data):
        self.storage.write(self.piece_length * index + begin, data)

    def _write_to_buffer(self, piece, start, data):
        if self.write_buf_max <= self.request_size:
            while self.write_buf_list:
                self._flush_buffer(self.write_buf_list.pop(), True)
            self.write_raw(self.places[piece], start, data.viewSlice())
            data.release()
            return
        self.lastwrite = clock()
        self.write_buf_size += len(data)
        while self.write_buf_size > self.write_buf_max:
            self._flush_buffer(self.write_buf_list.pop(0), True)
        if piece in self.write_buf:
            self.write_buf_list.remove(piece)
        else:
            self.write_buf[piece] = []
        self.write_buf_list.append(piece)
        self.write_buf[piece].append((start, data))

    def _flush_buffer(self, piece, popped = False):
        l = self.write_buf[piece]
        l.sort()
        for start, data in l:
            self.write_buf_size -= len(data)
            self.write_raw(self.places[piece], start, data.viewSlice())
            data.release()
        del self.write_buf[piece]
        if not popped:
            self.write_buf_list.remove(piece)

    def sync(self):
        spots = {}
        for p in self.write_buf:
            spots[self.places[p]] = p
        l = spots.keys()
        l.sort()
        for i in l:
            self._flush_buffer(spots[i])
        try:
            self.storage.sync()
        except IOError, e:
            self.failed(getABCUtility().lang.get('ioerror') + ' - ' + exceptionArgsToString(e))
        except OSError, e:
            self.failed(getABCUtility().lang.get('oserror') + ' - ' + exceptionArgsToString(e))

    def releaseWriteBuffer(self):
        for p in self.write_buf:
            for b in self.write_buf[p]:
                b[1].release()

    def _move_piece(self, index, newpos):
        oldpos = self.places[index]
        if DEBUG:
            print 'moving', index, 'from', oldpos, 'to', newpos
        assert oldpos != index
        assert oldpos != newpos
        assert index == newpos or not self.places.has_key(newpos)
        ###############################################################
        # old = self.read_raw(oldpos, 0, self._piecelen(index))
        # self.write_raw(newpos, 0, old)
        # self.places[index] = newpos
        # if self.have[index] and (self.triple_check or self.double_check and index == newpos):
            # if self.triple_check:
                # old.release()
                # old = self.read_raw(newpos, 0, self._piecelen(index), flush_first = True)
            # if sha1(old.viewSlice()).digest() != self.hashes[index]:
                # old.release()
                # self.failed(getABCUtility().lang.get('corrupteddownload'))
                # return -1
        # old.release()
        ###############################################################
        # buf_div, buf_mod = divmod(self._piecelen(index), self.check_buf_max)
        # buf_div *= self.check_buf_max
        # if self.have[index] and (self.triple_check or self.double_check and index == newpos):
            # sh = sha1()
        # for s in xrange(0, buf_div, self.check_buf_max):
            # old = self.read_raw(oldpos, s, self.check_buf_max)
            # self.write_raw(newpos, s, old)
            # if self.have[index] and (self.triple_check or self.double_check and index == newpos):
                # if self.triple_check:
                    # old.release()
                    # old = self.read_raw(newpos, s, self.check_buf_max, flush_first = True)
                # sh.update(old.viewSlice())
            # old.release()
        # if buf_mod:
            # old = self.read_raw(oldpos, buf_div, buf_mod)
            # self.write_raw(newpos, buf_div, old)
            # if self.have[index] and (self.triple_check or self.double_check and index == newpos):
                # if self.triple_check:
                    # old.release()
                    # old = self.read_raw(newpos, buf_div, buf_mod, flush_first = True)
                # sh.update(old.viewSlice())
            # old.release()
        # self.places[index] = newpos
        
        # if self.have[index] and (self.triple_check or self.double_check and index == newpos) \
           # and sh.digest() != self.hashes[index]:
            # self.failed(getABCUtility().lang.get('corrupteddownload'))
            # return -1
        ###############################################################
        pos = 0
        end = self._piecelen(index)
        old = None
        if self.have[index] and (self.triple_check or self.double_check and index == newpos):
            sh = sha1()
        while pos < end:
            length = min(end - pos, self.check_buf_max)
            old = self.read_raw(oldpos, pos, length, buf = old)
            self.write_raw(newpos, pos, old.viewSlice())
            if self.have[index] and (self.triple_check or self.double_check and index == newpos):
                if self.triple_check:
                    old.setLength(0)
                    old = self.read_raw(newpos, pos, length, flush_first = True, buf = old)
                sh.update(old.viewSlice())
            old.setLength(0)
            pos += length
        if old is not None:
            old.release()
        self.places[index] = newpos

        if self.have[index] and (self.triple_check or self.double_check and index == newpos) \
           and sh.digest() != self.hashes[index]:
            self.failed(getABCUtility().lang.get('corrupteddownload'))
            return -1
        ###############################################################

        if self.blocked[index]:
            self.blocked_moveout.remove(index)
            if self.blocked[newpos]:
                self.blocked_movein.remove(index)
            else:
                self.blocked_movein.add(index)
        else:
            self.blocked_movein.remove(index)
            if self.blocked[newpos]:
                self.blocked_moveout.add(index)
            else:
                self.blocked_moveout.remove(index)

        return oldpos

    def _clear_space(self, index):
        h = self.holes.pop(0)
        n = h
        if self.blocked[n]: # assume not self.blocked[index]
            if not self.blocked_movein:
                self.blocked_holes.append(n)
                return True    # repeat
            if not self.places.has_key(n):
                b = self.blocked_movein.pop(0)
                oldpos = self._move_piece(b, n)
                if oldpos < 0:
                    return False
                n = oldpos
        if self.places.has_key(n):
            oldpos = self._move_piece(n, n)
            if oldpos < 0:
                return False
            n = oldpos
        if index == n or index in self.holes:
            if n == h:
                if not self.alloc_piece(n):
                    return None
            self.places[index] = n
            if self.blocked[n]:
                # because n may be a spot cleared 10 lines above, it's possible
                # for it to be blocked. While that spot could be left cleared
                # and a new spot allocated, this condition might occur several
                # times in a row, resulting in a significant amount of disk I/O,
                # delaying the operation of the engine. Rather than do this,
                # queue the piece to be moved out again, which will be performed
                # by the background allocator, with which data movement is
                # automatically limited.
                self.blocked_moveout.add(index)
            return False
        for p, v in self.places.items():
            if v == index:
                break
        else:
            self.failed(getABCUtility().lang.get('corrupteddownload'))
            return False
        self._move_piece(p, n)
        self.places[index] = index
        return False

    def piece_came_in(self, index, begin, piece, source = None):
        assert not self.have[index]

        if not self.places.has_key(index):
            while self._clear_space(index):
                pass
            if DEBUG:
                print 'new place for', index, 'at', self.places[index]
        if self.flag.isSet():
            piece.release()
            return False

        self.piece_history.setdefault(index, {})[source] = 1

        self._write_to_buffer(index, begin, piece)

        piecelength = len(piece)
        self.amount_obtained += piecelength
        self.dirty.setdefault(index, []).append([begin, piecelength])
        self.numactive[index] -= 1
        assert self.numactive[index] >= 0
        if not self.numactive[index]:
            del self.stat_active[index]
        if self.stat_new.has_key(index):
            del self.stat_new[index]

        if self.inactive_requests[index] or self.numactive[index]:
            return True

        # Whole piece is complete
        del self.dirty[index]
        if self.write_buf_max:
            self._flush_buffer(index)
        end = self._piecelen(index)
        ###############################################################
        # data = self.read_raw(self.places[index], 0, end, flush_first = self.triple_check)
        # sh = sha1(data.viewSlice())
        # data.release()
        ###############################################################
        # buf_div, buf_mod = divmod(end, self.check_buf_max)
        # buf_div *= self.check_buf_max
        # sh = sha1()
        # for s in xrange(0, buf_div, self.check_buf_max):
            # data = self.read_raw(self.places[index], s, self.check_buf_max, flush_first = self.triple_check)
            # sh.update(data.viewSlice())
            # data.release()
        # if buf_mod:
            # data = self.read_raw(self.places[index], buf_div, buf_mod, flush_first = self.triple_check)
            # sh.update(data.viewSlice())
            # data.release()
        ###############################################################
        pos = 0
        sh = sha1()
        data = None
        while pos < end:
            length = min(end - pos, self.check_buf_max)
            data = self.read_raw(self.places[index], pos, length, flush_first = self.triple_check, buf = data)
            sh.update(data.viewSlice())
            data.setLength(0)
            pos += length
        if data is not None:
            data.release()
        ###############################################################

        if sh.digest() != self.hashes[index]:
            self.amount_obtained -= end
            self.data_flunked(end, index)
            self.inactive_requests[index] = 1
            self.amount_inactive += end
            self.stat_numflunked += 1
            maxbad = max([0]+[bdg.stats.bad[index] for bdg in self.piece_history[index] if index in bdg.stats.bad])
            for bdg in self.piece_history[index]:
                if maxbad == 0 or index in bdg.stats.bad and bdg.stats.bad[index] == maxbad:
                    bdg.failed(index)
            self.piece_history[index].clear()
            return False

        # Whole piece is complete and good
        self.have[index] = True
        self.updateReceivedPieces(index)
        self.inactive_requests[index] = None
        self.waschecked[index] = True
        self.amount_left -= end
        self.stat_numdownloaded += 1

        del self.piece_history[index]

        if self.amount_left == 0:
            # Write resume data in case of computer crash
            self.updatetorrentdatafunc()
            self.finished()
        return True

    def request_lost(self, index, begin, length):
        #assert not (begin, length) in self.inactive_requests[index]
        if not (begin, length) in self.inactive_requests[index]:
            insort(self.inactive_requests[index], (begin, length))
            self.amount_inactive += length
            self.numactive[index] -= 1
            if not self.numactive[index]:
                del self.stat_active[index]
                if self.stat_new.has_key(index):
                    del self.stat_new[index]

    def get_piece(self, index, begin, length, checkoverload = False, buf = None):
        if not self.have[index]:
            return None, 'no piece'

        if self.checkpiecebeforeupload and not self.waschecked[index]:
            ###############################################################
            # data = self.read_raw(self.places[index], 0, self._piecelen(index), checkoverload = checkoverload)
            # if data is None:
                # return None, 'overload'
            # if sha1(data.viewSlice()).digest() != self.hashes[index]:
                # data.release()
                # self.failed(getABCUtility().lang.get('piecefailedhashcomplete'))
                # return None, 'hash check failed'
            # self.waschecked[index] = True
            # if begin == 0 and length == self._piecelen(index):
                # return data, ''     # optimization
            # data.release()
            ###############################################################
            # buf_div, buf_mod = divmod(self._piecelen(index), self.check_buf_max)
            # buf_div *= self.check_buf_max
            # sh = sha1()
            # for s in xrange(0, buf_div, self.check_buf_max):
                # data = self.read_raw(self.places[index], s, self.check_buf_max, checkoverload = checkoverload)
                # if data is None:
                    # return None, 'overload'
                # sh.update(data.viewSlice())
                # data.release()
            # if buf_mod:
                # data = self.read_raw(self.places[index], buf_div, buf_mod, checkoverload = checkoverload)
                # if data is None:
                    # return None, 'overload'
                # sh.update(data.viewSlice())
                # data.release()
            # if sh.digest() != self.hashes[index]:
                # self.failed(getABCUtility().lang.get('piecefailedhashcomplete'))
                # return None, 'hash check failed'
            # self.waschecked[index] = True
            ###############################################################
            pos = 0
            end = self._piecelen(index)
            sh = sha1()
            data = None
            while pos < end:
                length2 = min(end - pos, self.check_buf_max)
                data = self.read_raw(self.places[index], pos, length2, checkoverload = checkoverload, buf = data)
                if data is None:
                    return None, 'overload'
                sh.update(data.viewSlice())
                data.setLength(0)
                pos += length2
            if data is not None:
                data.release()
            if sh.digest() != self.hashes[index]:
                self.failed(getABCUtility().lang.get('piecefailedhashcomplete'))
                return None, 'hash check failed'
            self.waschecked[index] = True
            ###############################################################

        if begin + length > self._piecelen(index):
            return None, 'bad range'
        
        data = self.read_raw(self.places[index], begin, length, checkoverload = checkoverload, buf = buf)
        if data is None:
            return None, 'overload'
        return data, ''

    def read_raw(self, piece, begin, length, flush_first = False, checkoverload = False, buf = None):
        return self.storage.read(self.piece_length * piece + begin, length, flush_first, checkoverload, buf = buf)

    def set_file_readonly(self, n):
        try:
            self.storage.set_readonly(n)
        except IOError, e:
            self.failed(getABCUtility().lang.get('ioerror') + ' - ' + exceptionArgsToString(e))
        except OSError, e:
            self.failed(getABCUtility().lang.get('oserror') + ' - ' + exceptionArgsToString(e))

    def has_data(self, index):
        return index not in self.holes and index not in self.blocked_holes

    def doublecheck_data(self, pieces_to_check):
        if not self.double_check:
            return True
        sources = []
        for p, v in self.places.items():
            if pieces_to_check.has_key(v):
                sources.append(p)
        assert len(sources) == len(pieces_to_check)
        sources.sort()
        for index in sources:
            if self.have[index]:
                ###############################################################
                # piece = self.read_raw(self.places[index], 0, self._piecelen(index), flush_first = True)
                # if sha1(piece.viewSlice()).digest() != self.hashes[index]:
                    # piece.release()
                    # self.failed(getABCUtility().lang.get('corrupteddownload'))
                    # return False
                # piece.release()
                ###############################################################
                # buf_div, buf_mod = divmod(self._piecelen(index), self.check_buf_max)
                # buf_div *= self.check_buf_max
                # sh = sha1()
                # for s in xrange(0, buf_div, self.check_buf_max):
                    # data = self.read_raw(self.places[index], s, self.check_buf_max, flush_first = True)
                    # sh.update(data.viewSlice())
                    # data.release()
                # if buf_mod:
                    # data = self.read_raw(self.places[index], buf_div, buf_mod, flush_first = True)
                    # sh.update(data.viewSlice())
                    # data.release()
                # if sh.digest() != self.hashes[index]:
                    # self.failed(getABCUtility().lang.get('corrupteddownload'))
                    # return False
                ###############################################################
                pos = 0
                end = self._piecelen(index)
                sh = sha1()
                data = None
                while pos < end:
                    length = min(end - pos, self.check_buf_max)
                    data = self.read_raw(self.places[index], pos, length, flush_first = True, buf = data)
                    sh.update(data.viewSlice())
                    data.setLength(0)
                    pos += length
                if data is not None:
                    data.release()
                if sh.digest() != self.hashes[index]:
                    self.failed(getABCUtility().lang.get('piecefailedhashcomplete'))
                    return False
                ###############################################################
        return True

    def reblock(self, new_blocked):
        # assume downloads have already been canceled and chunks made inactive
        for i in xrange(len(new_blocked)):
            if new_blocked[i] and not self.blocked[i]:
                length = self._piecelen(i)
                self.amount_desired -= length
                if self.have[i]:
                    self.amount_obtained -= length
                    continue
                if self.inactive_requests[i] == 1:
                    self.amount_inactive -= length
                    continue
                inactive = 0
                for nb, nl in self.inactive_requests[i]:
                    inactive += nl
                self.amount_inactive -= inactive
                self.amount_obtained -= length - inactive

            if self.blocked[i] and not new_blocked[i]:
                length = self._piecelen(i)
                self.amount_desired += length
                if self.have[i]:
                    self.amount_obtained += length
                    continue
                if self.inactive_requests[i] == 1:
                    self.amount_inactive += length
                    continue
                inactive = 0
                for nb, nl in self.inactive_requests[i]:
                    inactive += nl
                self.amount_inactive += inactive
                self.amount_obtained += length - inactive

        self.blocked = new_blocked

        self.blocked_movein = Olist()
        self.blocked_moveout = Olist()
        for p, v in self.places.items():
            if p != v:
                if self.blocked[p] and not self.blocked[v]:
                    self.blocked_movein.add(p)
                elif self.blocked[v] and not self.blocked[p]:
                    self.blocked_moveout.add(p)

        self.holes.extend(self.blocked_holes)    # reset holes list
        self.holes.sort()
        self.numholes = float(len(self.holes))
        self.blocked_holes[:] = []

    '''
    Pickled data format:

    d['pieces'] = either a string containing a bitfield of complete pieces,
                    or the numeric value "1" signifying a seed.  If it is
                    a seed, d['places'] and d['partials'] should be empty
                    and needn't even exist.
    d['partials'] = [ piece, [ offset, length... ]... ]
                    a list of partial data that had been previously
                    downloaded, plus the given offsets.  Adjacent partials
                    are merged so as to save space, and so that if the
                    request size changes then new requests can be
                    calculated more efficiently.
    d['places'] = [ piece, place, {,piece, place ...} ]
                    the piece index, and the place it's stored.
                    If d['pieces'] specifies a complete piece or d['partials']
                    specifies a set of partials for a piece which has no
                    entry in d['places'], it can be assumed that
                    place[index] = index.  A place specified with no
                    corresponding data in d['pieces'] or d['partials']
                    indicates allocated space with no valid data, and is
                    reserved so it doesn't need to be hash-checked.
    '''
    def pickle(self):
        if self.have.complete() and not self.config['magnet']:
            return {'pieces': 1}
        pieces = Bitfield(len(self.hashes))
        places = []
        partials = []
        for p in xrange(len(self.hashes)):
            if self.blocked[p] or not self.places.has_key(p):
                continue
            h = self.have[p]
            pieces[p] = h
            pp = self.dirty.get(p)
            if not h and not pp:  # no data
                places.extend([self.places[p], self.places[p]])
            elif self.places[p] != p:
                places.extend([p, self.places[p]])
            if h or not pp:
                continue
            pp.sort()
            r = []
            while len(pp) > 1:
                if pp[0][0] + pp[0][1] == pp[1][0]:
                    pp[0][1] += pp[1][1]
                    del pp[1]
                else:
                    r.extend(pp[0])
                    del pp[0]
            r.extend(pp[0])
            partials.extend([p, r])
        return {'pieces': pieces.tostring(), 'places': places, 'partials': partials}

    def unpickle(self, data, valid_places):
        got = {}
        places = {}
        dirty = {}
        stat_active = {}
        stat_numfound = self.stat_numfound
        amount_obtained = self.amount_obtained
        amount_inactive = self.amount_inactive
        amount_left = self.amount_left
        inactive_requests = self.inactive_requests[:]
        restored_partials = []

        try:
            if data['pieces'] == 1:     # a seed
                assert not data.get('places', None)
                assert not data.get('partials', None)
                have = Bitfield(len(self.hashes), '\xFF' * ((len(self.hashes) - 1) / 8 + 1))
                _places = []
                _partials = []
            else:
                have = Bitfield(len(self.hashes), data['pieces'])
                _places = data['places']
                assert len(_places) % 2 == 0
                _places = [_places[x:x + 2] for x in xrange(0, len(_places), 2)]
                _partials = data['partials']
                assert len(_partials) % 2 == 0
                _partials = [_partials[x:x + 2] for x in xrange(0, len(_partials), 2)]

            for index, place in _places:
                if not valid_places[place]:
                    continue
                assert not got.has_key(index)
                assert not got.has_key(place)
                places[index] = place
                got[index] = 1
                got[place] = 1

            for index in xrange(len(self.hashes)):
                if have[index]:
                    if not places.has_key(index):
                        if not valid_places[index]:
                            have[index] = False
                            continue
                        assert not got.has_key(index)
                        places[index] = index
                        got[index] = 1
                    length = self._piecelen(index)
                    amount_obtained += length
                    stat_numfound += 1
                    amount_inactive -= length
                    amount_left -= length
                    inactive_requests[index] = None

            for index, plist in _partials:
                assert not dirty.has_key(index)
                assert not have[index]
                if not places.has_key(index):
                    if not valid_places[index]:
                        continue
                    assert not got.has_key(index)
                    places[index] = index
                    got[index] = 1
                assert len(plist) % 2 == 0
                plist = [plist[x:x + 2] for x in xrange(0, len(plist), 2)]
                dirty[index] = plist
                stat_active[index] = 1
                # invert given partials
                length = self._piecelen(index)
                l = []
                if plist[0][0] > 0:
                    l.append((0, plist[0][0]))
                for i in xrange(len(plist) - 1):
                    end = plist[i][0] + plist[i][1]
                    assert not end > plist[i + 1][0]
                    l.append((end, plist[i + 1][0] - end))
                end = plist[-1][0] + plist[-1][1]
                assert not end > length
                if end < length:
                    l.append((end, length - end))
                # split them to request_size
                ll = []
                amount_obtained += length
                amount_inactive -= length
                for nb, nl in l:
                    while nl > 0:
                        r = min(nl, self.request_size)
                        ll.append((nb, r))
                        amount_inactive += r
                        amount_obtained -= r
                        nb += self.request_size
                        nl -= self.request_size
                inactive_requests[index] = ll
                restored_partials.append(index)

            assert amount_obtained + amount_inactive == self.amount_desired
        except:
            return []   # invalid data, discard everything

        self.have = have
        p = 0
        for h in self.have:
            if h:
                self.updateReceivedPieces(p)
            p += 1
        self.places = places
        self.dirty = dirty
        self.stat_active = stat_active
        self.stat_numfound = stat_numfound
        self.amount_obtained = amount_obtained
        self.amount_inactive = amount_inactive
        self.amount_left = amount_left
        self.inactive_requests = inactive_requests

        return restored_partials
