# Written by Edward Keyes
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from threading import Event
from BitTornado.bitfield import Bitfield


class Statistics_Response:
    pass    # empty class


class Statistics:
    def __init__(self, upmeasure, downmeasure, connecter, httpdl,
                 rerequest_lastfailed, fdatflag, config):
        self.config = config
        self.upmeasure = upmeasure
        self.downmeasure = downmeasure
        self.connecter = connecter
        self.httpdl = httpdl
        self.downloader = connecter.downloader
        self.picker = connecter.downloader.picker
        self.storage = connecter.downloader.storage
        self.rerequest_lastfailed = rerequest_lastfailed
        self.fdatflag = fdatflag
        self.fdatactive = False
        self.piecescomplete = None
        self.placesopen = None
        self.storage_totalpieces = len(self.storage.hashes)
        self.filelistupdated = Event()

    def updateData(self):
        self.storage_totalpieces = len(self.storage.hashes)

    def set_dirstats(self, files, piece_length):
        self.files = files
        self.piecescomplete = 0
        self.placesopen = 0
        self.filelistupdated.set()
        filenum = len(self.files)
        frange = xrange(filenum)
        self.filepieces = [[] for x in frange]
        self.fileamtdone = filenum * [0.0]
        self.filecomplete = Bitfield(filenum)
        self.fileinplace = Bitfield(filenum)
        start = 0L
        for i in frange:
            l = self.files[i][1]
            if l == 0:
                self.fileamtdone[i] = 1.0
                self.filecomplete[i] = True
                self.fileinplace[i] = True
                self.storage.storage._close_file(self.files[i][0])
            else:
                self.filepieces[i] = range(int(start / piece_length), int((start + l - 1) / piece_length) + 1)
                start += l

    def update(self):
        s = Statistics_Response()
        s.multifile = (self.piecescomplete is not None)
        s.upTotal = self.upmeasure.get_total()
        s.downTotal = self.downmeasure.get_total()
        s.last_failed = self.rerequest_lastfailed()
        s.external_connection_made = self.connecter.external_connection_made
        if s.downTotal > 0:
            s.shareRating = float(s.upTotal) / s.downTotal
        elif s.upTotal == 0:
           s.shareRating = 0.0
        else:
           s.shareRating = -1.0
        s.numSeeds = self.picker.seeds_connected
        s.numOldSeeds = self.downloader.num_disconnected_seeds()
        s.numPeers = len(self.downloader.downloads) - s.numSeeds
        s.numCopies = 0.0
        if self.config['magnet'] or self.picker.numpiecesfrac == 0:
            s.numCopies2 = 0.0
        else:
            for i in self.picker.crosscount:
                if i == 0:
                    s.numCopies += 1
                else:
                    s.numCopies += 1 - i / self.picker.numpiecesfrac
                    break
            if self.picker.done:
                s.numCopies2 = s.numCopies + 1
            else:
                s.numCopies2 = 0.0
                for i in self.picker.crosscount2:
                    if i == 0:
                        s.numCopies2 += 1
                    else:
                        s.numCopies2 += 1 - i / self.picker.numpiecesfrac
                        break
        s.discarded = self.downloader.discarded
        s.numSeeds += self.httpdl.seedsfound
        s.numOldSeeds += self.httpdl.seedsfound
        if s.numPeers == 0 or self.picker.numpiecesfrac == 0:
            s.percentDone = 0.0
        else:
            s.percentDone = 100.0 * self.picker.totalcount / self.picker.numpiecesfrac / s.numPeers

        if self.config['magnet']:
            s.storage_totalpieces = 0
            s.storage_active = 0
            s.storage_new = 0
            s.storage_dirty = 0
            s.storage_justdownloaded = 0
            s.storage_numcomplete = 0
            s.storage_numflunked = 0
        else:
            s.storage_totalpieces = len(self.storage.hashes)
            s.storage_active = len(self.storage.stat_active)
            s.storage_new = len(self.storage.stat_new)
            s.storage_dirty = len(self.storage.dirty)
            numdownloaded = self.storage.stat_numdownloaded
            s.storage_justdownloaded = numdownloaded
            s.storage_numcomplete = self.storage.stat_numfound + numdownloaded
            s.storage_numflunked = self.storage.stat_numflunked

        if self.piecescomplete is None:     # not a multi-file torrent
            return s

        if self.fdatflag.isSet():
            if not self.fdatactive:
                self.fdatactive = True
        else:
            self.fdatactive = False

        if not self.config['magnet']:
            if self.piecescomplete != self.picker.numgot:
                for i in xrange(len(self.filecomplete)):
                    if self.filecomplete[i]:
                        continue
                    self.fileamtdone[i] = self.storage.receivedpieces[i] / float(len(self.filepieces[i]))
                    if self.fileamtdone[i] == 1:
                        self.filecomplete[i] = True
                self.piecescomplete = self.picker.numgot
                self.filelistupdated.set()

            if self.filelistupdated.isSet() or self.placesopen != len(self.storage.places):
                for i in xrange(len(self.filecomplete)):
                    if not self.filecomplete[i]:
                        continue
                    while self.filepieces[i]:
                        piece = self.filepieces[i][-1]
                        if self.storage.places[piece] != piece:
                            break
                        del self.filepieces[i][-1]
                    if not self.filepieces[i]:
                        self.storage.storage._close_file(self.files[i][0])
                        if not self.fileinplace[i]:
                            self.fileinplace[i] = True
                            self.storage.set_file_readonly(i)
                            self.filelistupdated.set()
                self.placesopen = len(self.storage.places)

        s.fileamtdone = self.fileamtdone
        s.filecomplete = self.filecomplete
        s.fileinplace = self.fileinplace
        s.filelistupdated = self.filelistupdated

        return s
