# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from threading import Event
from BitTornado.utility import getINIT_STATE


class DownloaderFeedback:
    def __init__(self, storagewrapper, choker, downloader, httpdl, sched,
                 upfunc, downfunc, extradataupfunc, leftfunc, file_length, finflag, sp,
                 statistics, config, statusfunc, interval, localdisplay):
        self.storagewrapper = storagewrapper
        self.choker = choker
        self.downloader = downloader
        self.httpdl = httpdl
        self.sched = sched
        self.upfunc = upfunc
        self.downfunc = downfunc
        self.extradataupfunc = extradataupfunc
        self.leftfunc = leftfunc
        self.file_length = file_length
        self.finflag = finflag
        self.sp = sp
        self.statistics = statistics
        self.config = config
        self.lastids = []
        self.doneprocessing = Event()
        self.doneprocessing.set()
        self.statusfunc = statusfunc
        self.interval = interval
        self.localdisplay = localdisplay
        self.httpseeddirection = getINIT_STATE()[1][0]
        self.autodisplay()

    def _rotate(self):
        cs = self.choker.connections
        for id in self.lastids:
            for i in xrange(len(cs)):
                if cs[i].get_id() == id:
                    return cs[i:] + cs[:i]
        return cs

    def spews(self):
        l = []
        totalspeed = 0.
        cs = self._rotate()
        self.lastids = [c.get_id() for c in cs]
        for c in cs:
            u = c.upload
            d = c.download
            a = {}
            a['dns'] = c.get_dns()
            a['rp'] = c.get_remoteport()
            a['pid'] = c.get_id()
            a['ci'] = c.clientinfo
            a['optimistic'] = (c is self.choker.connections[0])
            a['direction'] = getINIT_STATE()[c.is_locally_initiated()][c.is_encrypted()]
            a['uprate'] = u.measure.get_rate()
            a['uinterested'] = u.is_interested()
            a['uchoked'] = u.is_choked()
            a['downrate'] = d.measure.get_rate()
            a['dinterested'] = d.is_interested()
            a['dchoked'] = d.is_choked()
            a['snubbed'] = d._check_snubbed()
            a['utotal'] = u.measure.get_total()
            a['dtotal'] = d.measure.get_total()
            if self.config['magnet']:
                a['completed'] = None
            elif d.gothavebitfield:
                if len(d.have) > 0:
                    a['completed'] = min(1., (float(len(d.have) - d.have.nbzero)
                                      - d.have[-1] * self.storagewrapper.lastpieceremainfrac) / self.storagewrapper.piecenumberfrac)
                else:
                    a['completed'] = 1.0
            else:
                a['completed'] = None
            if self.config['magnet']:
                a['speed'] = None
            elif d.have.complete():
                a['speed'] = 0.
            elif d.gothave:
                a['speed'] = d.peermeasure.get_lastrate()
                totalspeed += a['speed']
            else:
                a['speed'] = None

            l.append(a)                                               

        for dl in self.httpdl.get_downloads():
            if dl.goodseed:
                a = {}
                a['dns'] = (dl.baseurl, 80)
                a['rp'] = None
                a['pid'] = ''
                a['ci'] = ''
                a['optimistic'] = False
                a['direction'] = self.httpseeddirection
                a['uprate'] = 0
                a['uinterested'] = False
                a['uchoked'] = False
                a['downrate'] = dl.measure.get_rate()
                a['dinterested'] = True
                a['dchoked'] = a['snubbed'] = not dl.active
                a['utotal'] = None
                a['dtotal'] = dl.measure.get_total()
                a['completed'] = 1.0
                a['speed'] = None
                totalspeed += a['speed']

                l.append(a)

        return l, totalspeed

    def gather(self):
        s = {}
        # Keep up and down and spew rate gathering at top (before statistics.update())
        # to get the more acurate values after the last updates of these measures
        s['up'] = self.upfunc()
        s['extradataup'] = self.extradataupfunc()
        if not self.finflag.isSet():
            s['down'] = self.downfunc()
        if self.sp.isSet():
            s['spew'], s['totspeed'] = self.spews()
        else:
            s['spew'] = None
            s['totspeed'] = 0.
        s['kicked'] = self.downloader.kicked.keys()
        s['banned'] = self.downloader.banned.keys()
        s['stats'] = self.statistics.update()

        if self.finflag.isSet():
            s['done'] = self.file_length
            return s

        obtained, desired = self.leftfunc()
        s['done'] = obtained
        s['wanted'] = desired
        if desired > 0:
            s['frac'] = float(obtained) / desired
        elif self.config['magnet']:
            s['frac'] = 0.0
        else:
            s['frac'] = 1.0
        s['ongoing'] = None
        s['act'] = None
        return s

    def autodisplay(self):
        self.sched(self.autodisplay, self.interval)
        if self.localdisplay.isSet():
            return
        if not self.doneprocessing.isSet():
            return
        self.doneprocessing.clear()
        stats = self.gather()
        if self.finflag.isSet():
            self.statusfunc(dpflag = self.doneprocessing, upRate = stats['up'],
                            extradataUpRate = stats['extradataup'],
                            statistics = stats['stats'], spew = stats['spew'],
                            totalspeed = stats['totspeed'],
                            kicked = stats['kicked'], banned = stats['banned'])
        else:
            self.statusfunc(dpflag = self.doneprocessing,
                            fractionDone = stats['frac'], ongoing = stats['ongoing'],
                            sizeWanted = stats['wanted'], sizeDone = stats['done'],
                            downRate = stats['down'], upRate = stats['up'],
                            extradataUpRate = stats['extradataup'],
                            activity = stats['act'], statistics = stats['stats'],
                            spew = stats['spew'], totalspeed = stats['totspeed'],
                            kicked = stats['kicked'], banned = stats['banned'])

    def manualdisplay(self, activity = None, fractionDone = None, ongoing = None):
        self.sched(self._manualdisplay, -1, [activity, fractionDone, ongoing])

    def _manualdisplay(self, activity, fractionDone, ongoing):
        stats = {}
        if self.sp.isSet():
            stats['spew'], stats['totspeed'] = self.spews()
        else:
            stats['spew'] = None
            stats['totspeed'] = 0.
        stats['kicked'] = self.downloader.kicked.keys()
        stats['banned'] = self.downloader.banned.keys()
        self.statusfunc(dpflag = None,
                        fractionDone = fractionDone, ongoing = ongoing,
                        sizeWanted = 0, sizeDone = 0,
                        extradataUpRate = self.extradataupfunc(),
                        activity = activity,
                        spew = stats['spew'], totalspeed = stats['totspeed'],
                        kicked = stats['kicked'], banned = stats['banned'])
