##############################################################################
# Module : dhtrerequester.py
# Author : Old King Cole, Bram Cohen
# Date   : 02/11/2009
#
# Description : DHT rerequester
#
##############################################################################
from random import shuffle
from time import clock

from BitTornado.utility import exceptionArgsToString, getABCUtility


class DHTRerequester:
    def __init__(self, infohash, config, dht, sched, errorfunc,
                 connect, howmany, unpauseflag, listenport):
        self.infohash = infohash
        self.dht = dht
        self.sched = sched
        self.errorfunc = errorfunc
        self.connect = connect
        self.howmany = howmany
        self.unpauseflag = unpauseflag
        if listenport is None:
            self.listenport = 0
        else:
            self.listenport = listenport
        self.last_announce = 0
        self.stopped = True
        self.minpeers = config['min_peers']
        self.interval = self.definterval = config['dhtrerequest_interval']
        self.announce_interval = 900
        # 0 : not announcing ; 1 : auto announcing ; 2 : manual announcing
        self.announcing = 0
        self.firstcall = True
        self.disconnected = False
        self.cycleindex = 0
        self.reset = False

    def setDisconnected(self, value):
        if value:
            self.interval = 60
        else:
            self.interval = self.definterval
        if not self.stopped:
            if self.announcing:
                self.reset = True
            else:
                self.stop()
                self.start()

    def start(self):
        if self.stopped:
            self.stopped = False
            self.firstcall = True
            self.rerequest(False)

    def stop(self):
        if not self.stopped:
            self.stopped = True
            self.cycleindex += 1

    def d(self, cycleindex):
        if cycleindex != self.cycleindex:
            return
        if not self.unpauseflag.isSet():
            self.stop()
            return
        if not self.announcing and ((self.howmany() < self.minpeers or clock() - self.last_announce > self.announce_interval)):
            self.rerequest(False)
        else:
            self._d()

    def _d(self):
        self.sched(self.d, self.interval, [self.cycleindex])

    def rerequest(self, manual):
        if self.stopped or not self.unpauseflag.isSet() or self.announcing:
            return
        if manual:
            self.announcing = 2
        else:
            self.announcing = 1
        self.last_announce = clock()
        self.dht.sched(self.dht.valueForKeyAndStore, 0, [self.infohash, self.listenport, self.gotPeers])

    def gotPeers(self, peerinfos):
        self.sched(self._gotPeers, 0, [peerinfos])

    def _gotPeers(self, peerinfos):
        if not self.stopped and self.unpauseflag.isSet():
            # Last call to gotPeers for a rerequest is performed with empty peerinfos
            if peerinfos:
                shuffle(peerinfos)
                self.connect([(peerinfo, 0, None, None, 2) for peerinfo in peerinfos], 1 - self.firstcall)
            else:
                self.firstcall = False
                if self.reset:
                    self.reset = False
                    self.announcing = 0
                    self.stop()
                    self.start()
                else:
                    if self.announcing == 1:
                        self._d()
                    self.announcing = 0
        elif not peerinfos:
            self.reset = False
            self.announcing = 0
            self.firstcall = False
            self.stopped = True
