# Written by Bram Cohen
# see LICENSE.txt for license information
# Updated and modified for ABC_OKC : Old King Cole

from random import randrange, shuffle
from time import clock


class Choker:
    def __init__(self, config, schedule, picker, done = lambda: False):
        self.config = config
        self.round_robin_period = config['upload_round_robin_period']
        self.rechoke_period = config['rechoke_period']
        self.schedule = schedule
        self.picker = picker
        self.connections = []
        self.last_preferred = 0
        self.last_round_robin = clock()
        self.done = done
        self.super_seed = False
        self.paused = False
        self.min_comp_for_request = config['min_comp_for_request']
        schedule(self._round_robin, self.rechoke_period)

    # def set_round_robin_period(self, x):
        # self.round_robin_period = x

    def _round_robin(self):
        self.schedule(self._round_robin, self.rechoke_period)
        if self.config['magnet']:
            return
        if self.super_seed:
            cons = range(len(self.connections))
            to_close = []
            count = self.config['min_uploads'] - self.last_preferred
            if count > 0:   # optimization
                shuffle(cons)
            for c in cons:
                i = self.picker.next_have(self.connections[c], count > 0)
                if i is None:
                    continue
                if i < 0:
                    to_close.append(self.connections[c])
                    continue
                self.connections[c].send_have(i)
                count -= 1
            for c in to_close:
                c.close()
        if self.last_round_robin + self.round_robin_period < clock():
            self.last_round_robin = clock()
            for i in xrange(1, len(self.connections)):
                c = self.connections[i]
                u = c.upload
                if u.is_choked() and u.is_interested():
                    self.connections = self.connections[i:] + self.connections[:i]
                    break
            ####################################
            # CPU hog trick
            # Check request more for incomplete peers if no seed is downloading
            if self.min_comp_for_request and self.picker.numpieces > 5000:
                seed = False
                for c in self.connections:
                    d = c.download
                    if not d.have.complete():
                        continue
                    seed = True
                    if d.measure.get_rate():
                        break
                else:
                    if seed:
                        for c in self.connections:
                            d = c.download
                            if not d.have.complete() and not d.choked and d.is_interested():
                                d._request_more()            
            ####################################
        self._rechoke()

    def _rechoke(self):
        if self.config['magnet']:
            return
        maxuploads = self.config['max_uploads']
        if self.paused or not maxuploads:
            for c in self.connections:
                c.upload.choke()
            return
        preferred = []
        if maxuploads > 1:
            for c in self.connections:
                u = c.upload
                if not u.is_interested():
                    continue
                if self.done():
                    r = u.get_rate()
                else:
                    d = c.download
                    r = d.get_rate()
                    if r < 1024 or d.is_snubbed():
                        continue
                preferred.append((-r, c))
            self.last_preferred = len(preferred)
            preferred.sort()
            del preferred[maxuploads - 1:]
            preferred = [x[1] for x in preferred]
        count = len(preferred)
        to_unchoke = []
        for c in self.connections:
            u = c.upload
            if c in preferred:
                to_unchoke.append(u)
            elif u.is_interested():
                if count < maxuploads:
                    to_unchoke.append(u)
                    count += 1
                else:
                    u.choke()
            else:
                u.choke()
        for u in to_unchoke:
            u.unchoke()

    def connection_made(self, connection, p = None):
        if p is None:
            p = randrange(-2, len(self.connections) + 1)
        self.connections.insert(max(p, 0), connection)
        self._rechoke()

    def connection_lost(self, connection, shutdown = False):
        self.connections.remove(connection)
        self.picker.lost_peer(connection)
        u = connection.upload
        if not shutdown and u.is_interested() and not u.is_choked():
            self._rechoke()

    def interested(self, connection):
        if connection.upload.is_choked():
            self._rechoke()

    def not_interested(self, connection):
        if not connection.upload.is_choked():
            self._rechoke()

    def set_super_seed(self):
        while self.connections:             # close all connections
            self.connections[0].close()
        self.picker.set_superseed()
        self.super_seed = True

    def pause(self, flag):
        self.paused = flag
        self._rechoke()
